/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.logging.Level;
import qz.Base64;
import qz.ByteArrayBuilder;
import qz.LogIt;

public class ByteUtilities {
    protected static final char[] HEXES_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final String HEXES = "0123456789ABCDEF";

    public static byte[] hexStringToByteArray(String s) throws NumberFormatException {
        byte[] data = new byte[]{};
        if (s != null && s.length() > 0) {
            if (s.length() > 2) {
                String[] split;
                if (s.length() >= 3 && s.contains("x")) {
                    s = s.startsWith("x") ? s.substring(1) : s;
                    s = s.endsWith("x") ? s.substring(0, s.length() - 1) : s;
                    split = s.split("x");
                } else {
                    split = s.split("(?<=\\G..)");
                }
                data = new byte[split.length];
                int i = 0;
                while (i < split.length) {
                    Integer signedByte = Integer.parseInt(split[i], 16);
                    data[i] = (byte)(signedByte & 0xFF);
                    ++i;
                }
            } else if (s.length() == 2) {
                data = new byte[]{Byte.parseByte(s)};
            }
        }
        return data;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEXES_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEXES_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public static int[] indicesOfSublist(byte[] array, byte[] sublist) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        if (array == null || sublist == null || array.length == 0 || sublist.length == 0 || sublist.length > array.length) {
            return new int[0];
        }
        int i = 0;
        while (i < array.length - sublist.length + 1) {
            block5: {
                int j = 0;
                while (j < sublist.length) {
                    if (array[i + j] == sublist[j]) {
                        ++j;
                        continue;
                    }
                    break block5;
                }
                indexes.add(i);
            }
            ++i;
        }
        int[] int_array = new int[indexes.size()];
        int i2 = 0;
        while (i2 < indexes.size()) {
            int_array[i2] = (Integer)indexes.get(i2);
            ++i2;
        }
        return int_array;
    }

    public static LinkedList<ByteArrayBuilder> splitByteArray(byte[] src, byte[] pattern, int count) throws NullPointerException, IndexOutOfBoundsException, ArrayStoreException {
        LinkedList<ByteArrayBuilder> byteArrayList = new LinkedList<ByteArrayBuilder>();
        int[] split = ByteUtilities.indicesOfSublist(src, pattern);
        count = count < 1 ? 1 : count;
        int _count = 1;
        int prev = 0;
        ByteArrayBuilder b = new ByteArrayBuilder();
        int[] nArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            byte[] temp = new byte[i - prev + pattern.length];
            System.arraycopy(src, prev, temp, 0, temp.length);
            b.append(temp);
            if (_count < count) {
                ++_count;
            } else {
                byteArrayList.add(b);
                b = new ByteArrayBuilder();
                _count = 1;
            }
            prev = i + pattern.length;
            ++n2;
        }
        if (!byteArrayList.contains(b)) {
            byteArrayList.add(b);
        }
        return byteArrayList;
    }

    public static byte[] intArrayToByteArray(int[] ints) {
        byte[] bytes = new byte[ints.length];
        int i = 0;
        while (i < ints.length) {
            bytes[i] = (byte)ints[i];
            ++i;
        }
        return bytes;
    }

    public static int[] binaryArrayToIntArray(boolean[] black) {
        int[] hex = new int[black.length / 8];
        int i = 0;
        while (i < hex.length) {
            int k = 0;
            while (k < 8) {
                int n = i;
                hex[n] = hex[n] + ((black[8 * i + k] ? 1 : 0) << 7 - k);
                ++k;
            }
            ++i;
        }
        return hex;
    }

    public static String getHexString(int[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        int[] nArray = raw;
        int n = raw.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            hex.append(HEXES.charAt((i & 0xF0) >> 4)).append(HEXES.charAt(i & 0xF));
            ++n2;
        }
        return hex.toString();
    }

    public static boolean isBlank(Object o) {
        if (o instanceof byte[]) {
            return ((byte[])o).length < 1;
        }
        if (o instanceof String) {
            return ((String)o).equals("");
        }
        LogIt.log(Level.WARNING, "Uchecked blank comparison.");
        return o == null;
    }

    public static boolean isBase64Image(String path) {
        return path.startsWith("data:image/") && path.contains(";base64,");
    }

    public static boolean isBase64PDF(String path) {
        return path.startsWith("data:application/pdf;base64,");
    }

    public static byte[] readBinaryFile(String file) throws IOException, MalformedURLException {
        int len;
        if (ByteUtilities.isBase64PDF(file)) {
            return Base64.decode(file.split(",")[1]);
        }
        URLConnection con = new URL(file).openConnection();
        InputStream in = con.getInputStream();
        int size = con.getContentLength();
        ByteArrayOutputStream out = size != -1 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream(20480);
        byte[] buffer = new byte[512];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }
}

