/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import qz.ByteArrayBuilder;
import qz.ByteUtilities;
import qz.LanguageType;
import qz.LogIt;
import qz.exception.InvalidRawImageException;

public class ImageWrapper {
    public static final int CHECK_BLACK = 0;
    public static final int CHECK_LUMA = 1;
    public static final int CHECK_ALPHA = 2;
    private int lumaThreshold = 127;
    private boolean[] imageAsBooleanArray;
    private int[] imageAsIntArray;
    private final ByteArrayBuilder byteBuffer = new ByteArrayBuilder();
    private int alphaThreshold = 127;
    private BufferedImage bufferedImage;
    private final LanguageType languageType;
    private Charset charset = Charset.defaultCharset();
    private int imageQuantizationMethod = 1;
    private int xPos = 0;
    private int yPos = 0;
    private int dotDensity = 32;

    public ImageWrapper(BufferedImage bufferedImage, LanguageType languageType) {
        this.bufferedImage = bufferedImage;
        this.languageType = languageType;
        LogIt.log("Loading BufferedImage");
        LogIt.log("Dimensions: " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight());
        this.init();
        if (languageType.requiresImageWidthValidated()) {
            this.validateImageWidth();
        }
    }

    public int getLumaThreshold() {
        return this.lumaThreshold;
    }

    public void setLumaThreshold(int lumaThreshold) {
        this.lumaThreshold = lumaThreshold;
    }

    public int getImageQuantizationMethod() {
        return this.imageQuantizationMethod;
    }

    public void setImageQuantizationMethod(int imageQuantizationMethod) {
        this.imageQuantizationMethod = imageQuantizationMethod;
    }

    public int getAlphaThreshold() {
        return this.alphaThreshold;
    }

    public void setAlphaThreshold(int alphaThreshold) {
        this.alphaThreshold = alphaThreshold;
    }

    public int getDotDensity() {
        return this.dotDensity;
    }

    public void setDotDensity(int dotDensity) {
        this.dotDensity = dotDensity;
    }

    public int getxPos() {
        return this.xPos;
    }

    public void setxPos(int xPos) {
        this.xPos = xPos;
    }

    public int getyPos() {
        return this.yPos;
    }

    public void setyPos(int yPos) {
        this.yPos = yPos;
    }

    private boolean isBlack(int rgbPixel) {
        Color color = new Color(rgbPixel, true);
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        switch (this.getImageQuantizationMethod()) {
            case 1: {
                if (a < this.getLumaThreshold()) {
                    return false;
                }
                int luma = (r * 299 + g * 587 + b * 114) / 1000;
                return luma < this.getLumaThreshold();
            }
            case 2: {
                return a > this.getAlphaThreshold();
            }
        }
        return color.equals(Color.BLACK);
    }

    private void generateBlackPixels() {
        LogIt.log("Converting image to monochrome");
        BufferedImage bi = this.bufferedImage;
        int h = bi.getHeight();
        int w = bi.getWidth();
        int[] rgbPixels = bi.getRGB(0, 0, w, h, null, 0, w);
        int i = 0;
        boolean[] pixels = new boolean[rgbPixels.length];
        int[] nArray = rgbPixels;
        int n = rgbPixels.length;
        int n2 = 0;
        while (n2 < n) {
            int rgbpixel = nArray[n2];
            pixels[i++] = this.languageType.requiresImageOutputInverted() ? !this.isBlack(rgbpixel) : this.isBlack(rgbpixel);
            ++n2;
        }
        this.setImageAsBooleanArray(pixels);
    }

    private byte[] getBytes() {
        LogIt.log("Generating byte array");
        int[] ints = this.getImageAsIntArray();
        byte[] bytes = new byte[ints.length];
        int i = 0;
        while (i < ints.length) {
            bytes[i] = (byte)ints[i];
            ++i;
        }
        return bytes;
    }

    private void generateIntArray() {
        LogIt.log("Packing bits");
        this.imageAsIntArray = new int[this.imageAsBooleanArray.length / 8];
        int i = 0;
        while (i < this.imageAsIntArray.length) {
            int k = 0;
            while (k < 8) {
                int n = i;
                this.imageAsIntArray[n] = this.imageAsIntArray[n] + ((this.imageAsBooleanArray[8 * i + k] ? 1 : 0) << 7 - k);
                ++k;
            }
            ++i;
        }
    }

    public byte[] getImageCommand() throws InvalidRawImageException, UnsupportedEncodingException {
        this.getByteBuffer().clear();
        switch (this.languageType) {
            case ESCP: 
            case ESCP2: {
                this.appendEpsonSlices(this.getByteBuffer());
                break;
            }
            case ZPLII: 
            case ZPL: {
                String zplHexAsString = ByteUtilities.getHexString(this.getImageAsIntArray());
                int byteLen = zplHexAsString.length() / 2;
                int perRow = byteLen / this.getHeight();
                StringBuilder zpl = new StringBuilder("^GFA,").append(byteLen).append(",").append(byteLen).append(",").append(perRow).append(",").append(zplHexAsString);
                this.getByteBuffer().append(zpl, this.charset);
                break;
            }
            case EPL2: 
            case EPL: {
                StringBuilder epl = new StringBuilder("GW").append(this.getxPos()).append(",").append(this.getyPos()).append(",").append(this.getWidth() / 8).append(",").append(this.getHeight()).append(",");
                this.getByteBuffer().append(epl, this.charset).append(this.getBytes());
                break;
            }
            case CPCL: {
                String cpclHexAsString = ByteUtilities.getHexString(this.getImageAsIntArray());
                StringBuilder cpcl = new StringBuilder("EG ").append(this.getWidth() / 8).append(" ").append(this.getHeight()).append(" ").append(this.getxPos()).append(" ").append(this.getyPos()).append(" ").append(cpclHexAsString);
                this.getByteBuffer().append(cpcl, this.charset);
                break;
            }
            default: {
                throw new InvalidRawImageException(String.valueOf(this.charset.name()) + " image conversion is not yet supported.");
            }
        }
        return this.getByteBuffer().getByteArray();
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    private boolean[] getImageAsBooleanArray() {
        return this.imageAsBooleanArray;
    }

    private void setImageAsBooleanArray(boolean[] imageAsBooleanArray) {
        this.imageAsBooleanArray = imageAsBooleanArray;
    }

    private int[] getImageAsIntArray() {
        return this.imageAsIntArray;
    }

    private void setImageAsIntArray(int[] imageAsIntArray) {
        this.imageAsIntArray = imageAsIntArray;
    }

    private void init() {
        LogIt.log("Initializing Image Fields");
        this.generateBlackPixels();
        this.generateIntArray();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    private ByteArrayBuilder getByteBuffer() {
        return this.byteBuffer;
    }

    private BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    private void setBufferedImage(BufferedImage buffer) {
        this.bufferedImage = buffer;
    }

    private void appendEpsonSlices(ByteArrayBuilder builder) {
        builder.append(new byte[]{27, 51, 24});
        int offset = 0;
        while (offset < this.getHeight()) {
            byte nL = (byte)(this.getWidth() % 256);
            byte nH = (byte)(this.getWidth() / 256);
            builder.append(new byte[]{27, 42, (byte)this.dotDensity, nL, nH});
            int x = 0;
            while (x < this.getWidth()) {
                int k = 0;
                while (k < 3) {
                    byte slice = 0;
                    int b = 0;
                    while (b < 8) {
                        int y = (offset / 8 + k) * 8 + b;
                        int i = y * this.getWidth() + x;
                        boolean v = false;
                        if (i < this.getImageAsBooleanArray().length) {
                            v = this.getImageAsBooleanArray()[i];
                        }
                        slice = (byte)(slice | (byte)((v ? 1 : 0) << 7 - b));
                        ++b;
                    }
                    builder.append(new byte[]{slice});
                    ++k;
                }
                ++x;
            }
            offset += 24;
            builder.append(new byte[]{10});
        }
        builder.append(new byte[]{27, 51, 30});
    }

    private void validateImageWidth() {
        BufferedImage oldBufferedImage = this.bufferedImage;
        int height = oldBufferedImage.getHeight();
        int width = oldBufferedImage.getWidth();
        if (width % 8 != 0) {
            int newWidth = (width / 8 + 1) * 8;
            BufferedImage newBufferedImage = new BufferedImage(newWidth, height, 2);
            Graphics2D g = newBufferedImage.createGraphics();
            g.drawImage((Image)oldBufferedImage, 0, 0, null);
            g.dispose();
            this.setBufferedImage(newBufferedImage);
            this.init();
        }
    }
}

