/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.print.PrintException;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.pdfbox.pdmodel.PDDocument;
import qz.ByteArrayBuilder;
import qz.LogIt;
import qz.PaperFormat;
import qz.PrintJobElement;
import qz.PrintJobElementType;
import qz.PrintJobState;
import qz.PrintJobType;
import qz.Printer;
import qz.RawPrinter;
import qz.exception.InvalidRawImageException;
import qz.exception.NullCommandException;

public class PrintJob
extends JLabel
implements Printable {
    private PrintJobState state = PrintJobState.STATE_CREATED;
    private final String title = "Print Job";
    private final ArrayList<PrintJobElement> rawData = new ArrayList();
    private Boolean running = true;
    private final int updateDelay = 100;
    private Printer printer;
    private PrintJobType type;
    private Graphics graphics;
    private PageFormat pageFormat;
    private int pageIndex;
    private PaperFormat paperSize;
    private String jobHost;
    private int jobPort;
    private boolean logPSFeatures;
    private boolean autoSize = false;
    private boolean alternatePrint;
    private int copies = 1;
    private int leftMargin = 0;
    private int topMargin = 0;

    public void cancel() {
        this.state = PrintJobState.STATE_CANCELLED;
        this.running = false;
    }

    public PrintJobState getJobState() {
        return this.state;
    }

    public String getTitle() {
        return "Print Job";
    }

    public void append(ByteArrayBuilder appendData, Charset charset) {
        this.type = PrintJobType.TYPE_RAW;
        try {
            PrintJobElement pje = new PrintJobElement(this, appendData, PrintJobElementType.TYPE_RAW, charset);
            this.rawData.add(pje);
        }
        catch (NullPointerException ex) {
            LogIt.log(Level.SEVERE, "Could not append data.", ex);
        }
    }

    public void appendImage(ByteArrayBuilder imagePath, Charset charset, String lang, int imageX, int imageY) {
        this.type = PrintJobType.TYPE_RAW;
        try {
            PrintJobElement pje = new PrintJobElement(this, imagePath, PrintJobElementType.TYPE_IMAGE, charset, lang, imageX, imageY);
            this.rawData.add(pje);
        }
        catch (NullPointerException ex) {
            LogIt.log(Level.SEVERE, "Could not append image.", ex);
        }
    }

    public void appendImage(ByteArrayBuilder imagePath, Charset charset, String lang, int dotDensity) {
        this.type = PrintJobType.TYPE_RAW;
        try {
            PrintJobElement pje = new PrintJobElement(this, imagePath, PrintJobElementType.TYPE_IMAGE, charset, lang, dotDensity);
            this.rawData.add(pje);
        }
        catch (NullPointerException ex) {
            LogIt.log(Level.SEVERE, "Could not append image.", ex);
        }
    }

    public void appendPSImage(ByteArrayBuilder url, Charset charset) {
        this.type = PrintJobType.TYPE_PS;
        PrintJobElement pje = new PrintJobElement(this, url, PrintJobElementType.TYPE_IMAGE_PS, charset);
        this.rawData.add(pje);
    }

    public void appendXML(ByteArrayBuilder url, Charset charset, String xmlTag) {
        this.type = PrintJobType.TYPE_RAW;
        PrintJobElement pje = new PrintJobElement(this, url, PrintJobElementType.TYPE_XML, charset, xmlTag);
        this.rawData.add(pje);
    }

    public void appendFile(ByteArrayBuilder url, Charset charset) {
        this.type = PrintJobType.TYPE_RAW;
        PrintJobElement pje = new PrintJobElement(this, url, PrintJobElementType.TYPE_FILE, charset);
        this.rawData.add(pje);
    }

    public void appendRtfFile(ByteArrayBuilder url, Charset charset) {
        this.type = PrintJobType.TYPE_RTF;
        PrintJobElement pje = new PrintJobElement(this, url, PrintJobElementType.TYPE_RTF, charset);
        this.rawData.add(pje);
    }

    public void appendHTML(ByteArrayBuilder html, Charset charset) {
        this.type = PrintJobType.TYPE_HTML;
        PrintJobElement pje = new PrintJobElement(this, html, PrintJobElementType.TYPE_HTML, charset);
        this.rawData.add(pje);
    }

    public void appendPDF(ByteArrayBuilder url, Charset charset) {
        this.type = PrintJobType.TYPE_PDF;
        PrintJobElement pje = new PrintJobElement(this, url, PrintJobElementType.TYPE_PDF, charset);
        this.rawData.add(pje);
    }

    public void prepareJob() {
        this.state = PrintJobState.STATE_PROCESSING;
        ListIterator<PrintJobElement> dataIterator = this.rawData.listIterator();
        while (dataIterator.hasNext()) {
            try {
                PrintJobElement pje = dataIterator.next();
                pje.prepare();
            }
            catch (IOException ex) {
                LogIt.log(Level.SEVERE, "Could not prepare job.", ex);
            }
            catch (InvalidRawImageException ex) {
                LogIt.log(Level.SEVERE, "Invalid raw image.", ex);
            }
            catch (NullCommandException ex) {
                LogIt.log(Level.SEVERE, "Null command.", ex);
            }
        }
    }

    public void isProcessed() {
        ListIterator<PrintJobElement> dataIterator = this.rawData.listIterator();
        Boolean prepared = true;
        while (dataIterator.hasNext()) {
            PrintJobElement pje = dataIterator.next();
            if (pje.isPrepared()) continue;
            prepared = false;
            break;
        }
        if (prepared.booleanValue()) {
            LogIt.log("Done preparing PrintJob.");
            this.state = PrintJobState.STATE_PROCESSED;
        }
    }

    public void queue() {
        this.state = PrintJobState.STATE_QUEUED;
    }

    public String getInfo() {
        String jobInfo = "";
        if (this.type == PrintJobType.TYPE_RAW) {
            ListIterator<PrintJobElement> dataIterator = this.rawData.listIterator();
            while (dataIterator.hasNext()) {
                PrintJobElement pje = dataIterator.next();
                ByteArrayBuilder bytes = pje.getData();
                try {
                    String info = new String(bytes.getByteArray(), pje.getCharset().name());
                    jobInfo = String.valueOf(jobInfo) + info;
                }
                catch (UnsupportedEncodingException ex) {
                    LogIt.log(Level.SEVERE, "Unsupported encoding.", ex);
                }
            }
        } else {
            LogIt.log(Level.WARNING, "Unsupported job type.");
        }
        return jobInfo;
    }

    public void print() {
        this.state = PrintJobState.STATE_SENDING;
        int i = 0;
        while (i < this.copies) {
            block58: {
                HashPrintRequestAttributeSet attr;
                PrinterJob job;
                PrintJobElement firstElement;
                ListIterator<PrintJobElement> dataIterator;
                ByteArrayBuilder jobData;
                if (this.type == PrintJobType.TYPE_RAW) {
                    jobData = new ByteArrayBuilder();
                    dataIterator = this.rawData.listIterator();
                    while (dataIterator.hasNext()) {
                        PrintJobElement pje = dataIterator.next();
                        ByteArrayBuilder bytes = pje.getData();
                        jobData.append(bytes.getByteArray());
                    }
                    try {
                        this.printer.setJobTitle("Print Job");
                        if (this.jobHost != null) {
                            RawPrinter rawPrinter = (RawPrinter)this.printer;
                            rawPrinter.printToHost(jobData, this.jobHost, this.jobPort);
                            break block58;
                        }
                        if (this.alternatePrint) {
                            this.printer.printAlternate(jobData);
                            break block58;
                        }
                        this.printer.printRaw(jobData);
                    }
                    catch (PrintException ex) {
                        LogIt.log(Level.SEVERE, "Could not print raw job.", ex);
                    }
                } else if (this.type == PrintJobType.TYPE_HTML) {
                    jobData = new ByteArrayBuilder();
                    dataIterator = this.rawData.listIterator();
                    Charset charset = null;
                    while (dataIterator.hasNext()) {
                        PrintJobElement pje = dataIterator.next();
                        ByteArrayBuilder bytes = pje.getData();
                        jobData.append(bytes.getByteArray());
                        charset = pje.getCharset();
                    }
                    JFrame j = new JFrame("Print Job");
                    j.setUndecorated(true);
                    j.setLayout(new FlowLayout());
                    this.setBorder(null);
                    String jobDataString = null;
                    try {
                        if (charset != null) {
                            jobDataString = new String(jobData.getByteArray(), charset.name());
                        }
                        jobDataString = String.valueOf(jobDataString) + "</html>";
                    }
                    catch (UnsupportedEncodingException ex) {
                        LogIt.log(Level.SEVERE, "Unsupported encoding.", ex);
                    }
                    this.setText(jobDataString);
                    j.add(this);
                    j.pack();
                    j.setExtendedState(1);
                    j.setVisible(true);
                    HashPrintRequestAttributeSet attr2 = new HashPrintRequestAttributeSet();
                    attr2.add(new MediaPrintableArea(0.0f, 0.0f, (float)this.getWidth() / 72.0f, (float)(this.getHeight() + this.topMargin) / 72.0f, 25400));
                    PrinterJob job2 = PrinterJob.getPrinterJob();
                    try {
                        job2.setPrintService(this.printer.getPrintService());
                    }
                    catch (PrinterException ex) {
                        LogIt.log(Level.SEVERE, "Could not print HTML job.", ex);
                    }
                    if (this.logPSFeatures) {
                        this.logSupportedPrinterFeatures(job2);
                    }
                    job2.setPrintable(this);
                    job2.setJobName("Print Job");
                    try {
                        job2.print(attr2);
                    }
                    catch (PrinterException ex) {
                        LogIt.log(Level.SEVERE, "Could not print HTML job.", ex);
                    }
                    j.setVisible(false);
                    j.dispose();
                } else if (this.type == PrintJobType.TYPE_RTF) {
                    LogIt.log(Level.WARNING, "Current printer reported no PostScript support.");
                    try {
                        firstElement = this.rawData.get(0);
                        job = PrinterJob.getPrinterJob();
                        if (this.logPSFeatures) {
                            this.logSupportedPrinterFeatures(job);
                        }
                        int w = firstElement.getRtfWidth();
                        int h = firstElement.getRtfHeight();
                        attr = new HashPrintRequestAttributeSet();
                        job.setPrintService(this.printer.getPrintService());
                        JEditorPane rtfData = firstElement.getRtfData();
                        Class<?> c = rtfData.getClass();
                        Class[] paramList = new Class[]{MessageFormat.class, MessageFormat.class};
                        Method m = c.getMethod("getPrintable", paramList);
                        MessageFormat format = new MessageFormat("");
                        Printable p = (Printable)m.invoke((Object)rtfData, format, format);
                        job.setPrintable(p);
                        job.setJobName("Print Job");
                        job.print(attr);
                    }
                    catch (PrinterException ex) {
                        LogIt.log(Level.SEVERE, "Could not print RTF job.", ex);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        LogIt.log(Level.SEVERE, "Could not print RTF job.", ex);
                    }
                    catch (IllegalAccessException ex) {
                        LogIt.log(Level.SEVERE, "Could not print RTF job.", ex);
                    }
                    catch (InvocationTargetException ex) {
                        LogIt.log(Level.SEVERE, "Could not print RTF job.", ex);
                    }
                    catch (NoSuchMethodException ex) {
                        LogIt.log(Level.WARNING, "RTF printing requires this applet to be compiled with Java >= 1.6");
                    }
                    catch (IllegalArgumentException ex) {
                        LogIt.log(Level.SEVERE, "Illegal argument exception. " + ex);
                    }
                } else if (this.type == PrintJobType.TYPE_PDF) {
                    LogIt.log(Level.WARNING, "Current printer reported no PostScript support.");
                    PDDocument pdfFile = null;
                    try {
                        try {
                            while (pdfFile == null) {
                                pdfFile = this.rawData.get(0).getPDFFile();
                            }
                            job = PrinterJob.getPrinterJob();
                            job.setPrintService(this.printer.getPrintService());
                            pdfFile.silentPrint(job);
                        }
                        catch (PrinterException ex) {
                            LogIt.log(Level.SEVERE, "There was an error printing this job. " + ex);
                            try {
                                if (pdfFile != null) {
                                    pdfFile.close();
                                }
                                break block58;
                            }
                            catch (IOException ex2) {
                                LogIt.log(Level.WARNING, "Could not close PDF file. " + ex2);
                            }
                            break block58;
                        }
                    }
                    catch (Throwable w) {
                        try {
                            if (pdfFile != null) {
                                pdfFile.close();
                            }
                        }
                        catch (IOException ex) {
                            LogIt.log(Level.WARNING, "Could not close PDF file. " + ex);
                        }
                        throw w;
                    }
                    try {
                        if (pdfFile != null) {
                            pdfFile.close();
                        }
                    }
                    catch (IOException ex) {
                        LogIt.log(Level.WARNING, "Could not close PDF file. " + ex);
                    }
                } else if (this.type == PrintJobType.TYPE_PS) {
                    LogIt.log(Level.WARNING, "Current printer reported no PostScript support.");
                    try {
                        int h;
                        int w;
                        firstElement = this.rawData.get(0);
                        job = PrinterJob.getPrinterJob();
                        if (this.logPSFeatures) {
                            this.logSupportedPrinterFeatures(job);
                        }
                        if (firstElement.getBufferedImage() != null) {
                            w = firstElement.getBufferedImage().getWidth();
                            h = firstElement.getBufferedImage().getHeight();
                        } else if (firstElement.getRtfData() != null) {
                            w = firstElement.getRtfWidth();
                            h = firstElement.getRtfHeight();
                        } else {
                            throw new PrinterException("Corrupt or missing file supplied.");
                        }
                        attr = new HashPrintRequestAttributeSet();
                        if (this.paperSize != null) {
                            attr.add(this.paperSize.getOrientationRequested());
                            if (this.paperSize.isAutoSize() && this.rawData.get(0).getType() == PrintJobElementType.TYPE_IMAGE_PS) {
                                this.paperSize.setAutoSize(this.rawData.get(0).getBufferedImage());
                            }
                            attr.add(new MediaPrintableArea(0.0f, 0.0f, this.paperSize.getAutoWidth(), this.paperSize.getAutoHeight(), this.paperSize.getUnits()));
                        } else {
                            attr.add(new MediaPrintableArea(0.0f, 0.0f, (float)(w + this.leftMargin) / 72.0f, (float)(h + this.topMargin) / 72.0f, 25400));
                        }
                        job.setPrintService(this.printer.getPrintService());
                        job.setPrintable(this);
                        job.setJobName("Print Job");
                        job.print(attr);
                    }
                    catch (PrinterException ex) {
                        LogIt.log(Level.SEVERE, "Could not print PostScript job.", ex);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        LogIt.log(Level.SEVERE, "Could not print PostScript job.", ex);
                    }
                } else {
                    LogIt.log(Level.WARNING, "Unsupported job type.");
                }
            }
            ++i;
        }
        this.state = PrintJobState.STATE_COMPLETE;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex < this.rawData.size()) {
            PrintJobElement pje = this.rawData.get(pageIndex);
            if (pje.getType() == PrintJobElementType.TYPE_IMAGE_PS) {
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                BufferedImage imgToPrint = pje.getBufferedImage();
                if (this.autoSize) {
                    g2d.drawImage(imgToPrint, this.leftMargin, this.topMargin, (int)pageFormat.getImageableWidth() - this.leftMargin, (int)pageFormat.getImageableHeight() - this.topMargin, imgToPrint.getMinX(), imgToPrint.getMinY(), imgToPrint.getWidth(), imgToPrint.getHeight(), null);
                } else {
                    g2d.drawImage(imgToPrint, this.leftMargin, this.topMargin, imgToPrint.getWidth() + this.leftMargin, imgToPrint.getHeight() + this.topMargin, imgToPrint.getMinX(), imgToPrint.getMinY(), imgToPrint.getWidth(), imgToPrint.getHeight(), null);
                }
                return 0;
            }
            if (pje.getType() == PrintJobElementType.TYPE_HTML) {
                boolean doubleBuffered = super.isDoubleBuffered();
                super.setDoubleBuffered(false);
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.translate(pageFormat.getImageableX() + (double)this.leftMargin, pageFormat.getImageableY() + (double)this.topMargin);
                this.paint(g2d);
                super.setDoubleBuffered(doubleBuffered);
                return 0;
            }
        }
        return 1;
    }

    public void setHostOutput(String jobHost, int jobPort) {
        this.jobHost = jobHost;
        this.jobPort = jobPort;
        this.printer = new RawPrinter();
    }

    public void setPaperSize(PaperFormat paperSize) {
        this.paperSize = paperSize;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    private void logSupportedPrinterFeatures(PrinterJob job) {
        LogIt.log("Supported Printing Attributes:");
        Class<?>[] classArray = job.getPrintService().getSupportedAttributeCategories();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            LogIt.log("   Attr type = " + cl + "=" + job.getPrintService().getDefaultAttributeValue(cl));
            ++n2;
        }
    }

    void setLogPostScriptFeatures(boolean logPSFeatures) {
        this.logPSFeatures = logPSFeatures;
    }

    void setAlternatePrinting(boolean alternatePrint) {
        this.alternatePrint = alternatePrint;
    }

    void setCopies(int copies) {
        if (copies > 0) {
            LogIt.log(Level.INFO, "[PrintJob] Copies set to " + copies);
            this.copies = copies;
        } else {
            LogIt.log(Level.WARNING, "Copies must be a positive integer.");
        }
    }

    int getCopies() {
        return this.copies;
    }
}

