/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.IOException;
import java.util.logging.Level;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import jssc.SerialPortTimeoutException;
import qz.ByteArrayBuilder;
import qz.ByteUtilities;
import qz.LogIt;
import qz.SerialUtilities;
import qz.exception.SerialException;

public class SerialIO {
    private int baudRate = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int flowControl = 0;
    private int parity = 0;
    private byte[] begin = new byte[]{2};
    private byte[] end = new byte[]{13};
    private int timeout;
    private ByteArrayBuilder outputBuffer;
    private ByteArrayBuilder inputBuffer;
    private byte[] output;
    private SerialPort port;
    private String serialPorts;
    private String[] portArray;
    private String portName;

    public SerialIO() {
        this.setTimeout(1200);
    }

    public boolean close() throws SerialPortException {
        if (this.port == null || !this.port.isOpened()) {
            LogIt.log(Level.WARNING, "Serial Port [" + this.portName + "] does not appear to be open.");
            return false;
        }
        boolean closed = this.port.closePort();
        if (!closed) {
            LogIt.log(Level.WARNING, "Serial Port [" + this.portName + "] was not closed properly.");
        } else {
            LogIt.log("Port [" + this.portName + "] closed successfully.");
        }
        this.port = null;
        this.portName = null;
        return closed;
    }

    public byte[] getOutput() {
        return this.output;
    }

    public void clearOutput() {
        this.output = null;
    }

    private ByteArrayBuilder getOutputBuffer() {
        if (this.outputBuffer == null) {
            this.outputBuffer = new ByteArrayBuilder();
        }
        return this.outputBuffer;
    }

    public ByteArrayBuilder getInputBuffer() {
        if (this.inputBuffer == null) {
            this.inputBuffer = new ByteArrayBuilder();
        }
        return this.inputBuffer;
    }

    public boolean open(String portName) throws SerialPortException {
        if (this.port == null) {
            this.portName = portName;
            this.port = new SerialPort(this.portName);
            try {
                this.port.openPort();
                this.port.addEventListener(new SerialPortEventListener(){

                    public void serialEvent(SerialPortEvent e) {
                        SerialIO.this.serialEvent(e);
                    }
                });
            }
            catch (SerialPortException e) {
                this.port = null;
                throw e;
            }
        } else {
            LogIt.log(Level.WARNING, "Serial Port [" + this.portName + "] already appears to be open.");
        }
        return this.port.isOpened();
    }

    public void autoSetProperties() throws SerialPortException, IOException, SerialException {
        int[] params = SerialUtilities.getSystemAttributes(this.portName);
        this.port.setParams(params[0], params[1], params[2], params[3]);
        this.port.setFlowControlMode(params[4]);
    }

    public void setProperties(String baud, String dataBits, String stopBits, String parity, String flowControl) throws SerialPortException {
        this.baudRate = SerialUtilities.parseBaudRate(baud);
        this.dataBits = SerialUtilities.parseDataBits(dataBits);
        this.stopBits = SerialUtilities.parseStopBits(stopBits);
        this.parity = SerialUtilities.parseParity(parity);
        this.flowControl = SerialUtilities.parseFlowControl(flowControl);
    }

    public boolean open(int portID) throws SerialPortException, SerialException {
        if (this.serialPorts == null) {
            this.getSerialPorts();
        }
        if (this.serialPorts.equals("")) {
            throw new SerialException("No ports could be found on this system");
        }
        if (portID > -1 && this.portArray.length > 0 && this.portArray.length > portID) {
            return this.open(this.portArray[portID]);
        }
        throw new SerialException("Index supplied [" + portID + "] is " + "out of bounds in the following port listing: " + this.serialPorts);
    }

    public String getSerialPorts() {
        return this.serialPorts;
    }

    public String getPortName() {
        return this.portName;
    }

    public String fetchSerialPorts() {
        StringBuilder sb = new StringBuilder();
        this.portArray = SerialPortList.getPortNames();
        for (int i = 0; i < this.portArray.length; ++i) {
            sb.append(this.portArray[i]).append(i < this.portArray.length - 1 ? "," : "");
        }
        this.serialPorts = sb.toString();
        return this.serialPorts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void serialEvent(SerialPortEvent event) {
        try {
            if (event.isRXCHAR()) {
                this.getOutputBuffer().append(this.port.readBytes(event.getEventValue(), this.timeout));
                int[] beginPos = ByteUtilities.indicesOfSublist(this.getOutputBuffer().getByteArray(), this.begin);
                int[] endPos = ByteUtilities.indicesOfSublist(this.getOutputBuffer().getByteArray(), this.end);
                if (beginPos.length > 0 && endPos.length > 0) {
                    int _begin = beginPos[beginPos.length - 1];
                    int _end = endPos[endPos.length - 1];
                    LogIt.log(new String(this.getOutputBuffer().getByteArray(), _begin, _end - _begin));
                    this.output = new byte[_end - _begin];
                    System.arraycopy(this.getOutputBuffer().getByteArray(), _begin, this.output, 0, _end - _begin);
                    this.getOutputBuffer().clear();
                }
            }
        }
        catch (SerialPortException e) {
            LogIt.log(Level.SEVERE, "Exception occured while reading data from port.", e);
        }
        catch (SerialPortTimeoutException e) {
            LogIt.log(Level.WARNING, "Timeout occured waiting for port to respond.  Timeout value: " + this.timeout, e);
        }
    }

    public boolean isOpen() {
        return this.port == null ? false : this.port.isOpened();
    }

    public void send() throws SerialPortException {
        this.port.setParams(this.baudRate, this.dataBits, this.stopBits, this.parity);
        this.port.setFlowControlMode(this.flowControl);
        LogIt.log("Sending data to [" + this.portName + "]:\r\n\r\n" + new String(this.getInputBuffer().getByteArray()) + "\r\n\r\n");
        this.port.writeBytes(this.getInputBuffer().getByteArray());
        this.getInputBuffer().clear();
    }

    public void append(byte[] bytes) {
        this.getInputBuffer().append(bytes);
    }

    public byte[] getBegin() {
        return this.begin;
    }

    public void setBegin(byte[] begin) {
        this.begin = begin;
    }

    public byte[] getEnd() {
        return this.end;
    }

    public void setEnd(byte[] end) {
        this.end = end;
    }
}

