/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;
import qz.Base64;
import qz.ByteArrayBuilder;
import qz.ByteUtilities;
import qz.FileUtilities;
import qz.ImageWrapper;
import qz.LanguageType;
import qz.LogIt;
import qz.PrintJobElement;
import qz.PrintJobElementType;
import qz.exception.InvalidRawImageException;
import qz.exception.NullCommandException;

public class PrintJobElementPreparer
implements Runnable {
    private final PrintJobElementType type;
    private final ByteArrayBuilder data;
    private final Charset charset;
    private final PrintJobElement pje;
    private String pdfFileName;
    private ByteArrayBuilder preparedData;
    private BufferedImage bufferedImage;
    private PDDocument pdfFile;
    private JEditorPane rtfEditor;

    PrintJobElementPreparer(PrintJobElementType type, ByteArrayBuilder data, Charset charset, PrintJobElement pje) {
        this.type = type;
        this.data = data;
        this.charset = charset;
        this.pje = pje;
    }

    @Override
    public void run() {
        block37: {
            if (this.type == PrintJobElementType.TYPE_IMAGE) {
                try {
                    BufferedImage bi;
                    String file = new String(this.data.getByteArray(), this.charset.name());
                    if (ByteUtilities.isBase64Image(file)) {
                        byte[] imageData = Base64.decode(file.split(",")[1]);
                        bi = ImageIO.read(new ByteArrayInputStream(imageData));
                    } else {
                        bi = ImageIO.read(new URL(file));
                    }
                    LanguageType lang = this.pje.getLang();
                    ImageWrapper iw = new ImageWrapper(bi, lang);
                    iw.setCharset(this.charset);
                    iw.setDotDensity(this.pje.getDotDensity());
                    iw.setxPos(this.pje.getImageX());
                    iw.setyPos(this.pje.getImageY());
                    this.preparedData = new ByteArrayBuilder(iw.getImageCommand());
                }
                catch (UnsupportedEncodingException ex) {
                    LogIt.log(Level.WARNING, "Unsupported encoding exception: " + ex);
                }
                catch (IOException ex) {
                    LogIt.log(Level.WARNING, "IO exception: " + ex);
                }
                catch (InvalidRawImageException ex) {
                    LogIt.log(Level.WARNING, "Invalid raw image exception: " + ex);
                }
            } else if (this.type == PrintJobElementType.TYPE_IMAGE_PS) {
                try {
                    String file = new String(this.data.getByteArray(), this.charset.name());
                    if (ByteUtilities.isBase64Image(file)) {
                        byte[] imgData = Base64.decode(file.split(",")[1]);
                        ByteArrayInputStream in = new ByteArrayInputStream(imgData);
                        this.bufferedImage = ImageIO.read(in);
                        break block37;
                    }
                    this.bufferedImage = ImageIO.read(new URL(file));
                }
                catch (UnsupportedEncodingException ex) {
                    LogIt.log(Level.WARNING, "Unsupported encoding exception: " + ex);
                }
                catch (IOException ex) {
                    LogIt.log(Level.WARNING, "IO exception: " + ex);
                }
            } else if (this.type == PrintJobElementType.TYPE_XML) {
                try {
                    String file = new String(this.data.getByteArray(), this.charset.name());
                    String dataString = FileUtilities.readXMLFile(file, this.pje.getXmlTag());
                    byte[] dataByteArray = Base64.decode(dataString);
                    this.preparedData = new ByteArrayBuilder(dataByteArray);
                }
                catch (UnsupportedEncodingException ex) {
                    LogIt.log(Level.WARNING, "Unsupported encoding exception: " + ex);
                }
                catch (IOException ex) {
                    LogIt.log(Level.WARNING, "IO exception: " + ex);
                }
                catch (DOMException ex) {
                    LogIt.log(ex);
                }
                catch (NullCommandException ex) {
                    LogIt.log(ex);
                }
                catch (ParserConfigurationException ex) {
                    LogIt.log(ex);
                }
                catch (SAXException ex) {
                    LogIt.log(ex);
                }
            } else if (this.type == PrintJobElementType.TYPE_FILE) {
                try {
                    String file = new String(this.data.getByteArray(), this.charset.name());
                    this.preparedData = new ByteArrayBuilder(FileUtilities.readRawFile(file));
                }
                catch (UnsupportedEncodingException ex) {
                    LogIt.log(ex);
                }
                catch (IOException ex) {
                    LogIt.log(ex);
                }
            } else if (this.type == PrintJobElementType.TYPE_RTF) {
                try {
                    String file = new String(this.data.getByteArray(), this.charset.name());
                    this.preparedData = new ByteArrayBuilder(FileUtilities.readRawFile(file));
                    this.rtfEditor = new JEditorPane();
                    this.rtfEditor.setBackground(Color.white);
                    this.rtfEditor.setVisible(false);
                    this.rtfEditor.setContentType("text/rtf");
                    this.rtfEditor.setText(new String(this.preparedData.getByteArray(), this.charset.name()));
                }
                catch (UnsupportedEncodingException ex) {
                    LogIt.log(ex);
                }
                catch (IOException ex) {
                    LogIt.log(ex);
                }
            } else if (this.type == PrintJobElementType.TYPE_PDF) {
                try {
                    this.pdfFileName = new String(this.data.getByteArray(), this.charset.name());
                }
                catch (UnsupportedEncodingException ex) {
                    LogIt.log(ex);
                }
                final String fileName = this.pdfFileName;
                LogIt.log("DEBUG: fileName - " + fileName);
                this.pdfFile = AccessController.doPrivileged(new PrivilegedAction<PDDocument>(){

                    @Override
                    public PDDocument run() {
                        try {
                            URL fileUrl = new URL(fileName);
                            return PDDocument.load((URL)fileUrl);
                        }
                        catch (IOException ex) {
                            LogIt.log("Error reading PDF file. " + ex);
                            return null;
                        }
                    }
                });
            } else {
                this.preparedData = this.data;
            }
        }
        this.pje.donePreparing(this.preparedData, this.bufferedImage, this.rtfEditor, this.pdfFile);
    }
}

